---
title: 컨펌 프로세스
description: 결제 승인의 주체를 고객사 서버로 가져갈 수 있는 서비스입니다.
targetVersions:
  - v2
versionVariants:
  v1: /opi/ko/extra/confirm-process/readme-v1
---

**해당 서비스는 결제 승인 직전에 고객사에서 결제 의사를 최종적으로 확인하는 서비스입니다.**

<div class="hint" data-style="info">

**수동 승인 기능 안내**

V2 신규 연동 시에는 컨펌 프로세스와 동일한 목적으로 사용할 수 있는 [수동 승인](https://developers.portone.io/opi/ko/extra/manual-confirm/readme-v2) 기능을 이용하시기를 권장합니다.
수동 승인은 더 간편한 연동 방식을 제공하며, 채널 설정에서 간단히 켤 수 있습니다.

</div>

(관련 이미지 첨부)

## 컨펌 프로세스란?

- 결제 승인 직전 고객사에 결제 승인 요청 의사를 마지막으로 확인하는 서비스입니다.

- 기본적인 결제 플로우상 고객사에서 결제 요청 후 별도의 확인 없이 결제 승인되는 구조입니다.
  하지만 해당 서비스 이용 시 고객사가 최종적으로 결제 승인 요청의 주체가 될 수 있습니다.

(이미지 첨부: 컨펌 프로세스 플로우)

<div class="hint" data-style="info">

**해당 서비스가 반드시 필요한 고객사는 아래와 같은 경우입니다.**

(관련 이미지 첨부)

- 판매 제품의 재고가 소량으로 재고파악이 필요한 경우 (한정된 상품 또는 고가 제품 판매시)
- 선착순 방식으로 결제가 진행되어야 하는 경우
- 결제 승인 전 마지막으로 고객사에서 처리하고 싶은 로직이 존재하는 경우

</div>

## 컨펌 프로세스 사용 케이스

### 판매 제품의 재고가 소량으로 재고파악이 필요한 경우

고객사의 판매 제품이 재고가 충분하지 않을 경우 구매자가 동시에 구매를 요청할 수 있기 때문에
결제 직전 고객사 서버에서 재고 수량을 한 번 더 확인하고 수량이 있는 경우에만 결제가 승인되도록
처리할 수 있습니다.\
만약 컨펌 프로세스를 설정하지 않는 경우 실제 결제 승인 후 재고가 부족하여 제품 발송이 늦어지거나
주문을 취소 처리가 발생하여 고객의 결제 경험 만족도를 저하시키는 상황이 반복될 수 있습니다.

![](</gitbook-assets/ko/image (217).png>)

### 선착순 방식으로 결제가 진행되어야 하는 경우

마라톤 참가 신청, 인기 콘서트 티켓팅 또는 OO Day 같은 특별 할인 행사처럼 특정 시간에 매우 많은 고객이
동시에 결제 요청을 하는 경우 한정된 수량을 초과하지 않도록 고객사에서 최종적으로 수량을 확인한 후
결제가 승인되도록 처리할 수 있습니다.

![](</gitbook-assets/ko/image (164).png>)

### 결제 승인 전 마지막으로 고객사에서 처리하고 싶은 로직이 존재하는 경우

이밖에 다른 사유로 고객사에서 결제 승인 완료 직전 자체 업무 처리가 필요한 경우(결제 직전 고객사 서버 헬스체크 등) 해당 서비스를 이용할 수 있습니다.

![](</gitbook-assets/ko/image (262).png>)

<div class="hint" data-style="info">

**컨펌 프로세스 신청 방법**

기술지원 메일(<tech.support@portone.io>)로 **상점 아이디**를 기재하여 메일 발송

포트원 콘솔 로그인 후 \[결제연동] 페이지 상단에서 상점 아이디를 확인 하실 수 있습니다.

</div>

<div class="hint" data-style="warning">

엑심베이의 경우 컨펌 프로세스 사용이 불가능합니다.

</div>

## 컨펌 프로세스 이용 방법

컨펌 프로세스 이용시 고객사는 `PortOne.requestPayment()`, `PortOne.loadPaymentUI()` 함수 호출 시

`confirmUrl` 파라미터를 정의하고 해당 파라미터에 고객사 EndPoint URL을 설정합니다.

```json title="JavaScript SDK"
{
  //...중략
  "confirmUrl": "고객사 EndPoint URL 기재"
  //...중략
}
```

## Payload Schema

콘솔에서 설정하신 웹훅 버전에 따라 상이한 형식의 payload가 송신됩니다.

### `2024-01-01` 사용 시

- `payment_id`: 고객사에서 채번한 결제건의 고유 주문 번호입니다.
- `tx_id`: 포트원에서 채번한 결제건의 고유 거래 번호입니다.
- `total_amount`: 결제건의 결제 요청 금액입니다.

**컨펌 웹훅 payload 예시:**

```json
{
  "payment_id": "example-payment-id",
  "tx_id": "55451513-9763-4a7a-bb43-78a4c65be843",
  "total_amount": 1000
}
```

### `2024-04-25` 사용 시

- `type`: 웹훅을 트리거한 이벤트의 타입입니다. 컨펌 웹훅의 경우 `type`의 값은 `Transaction.Confirm`으로 고정됩니다.

- `timestamp`: 해당 웹훅을 트리거한 이벤트의 발생 시각(RFC 3339 형식)입니다.

- `data`: 웹훅을 트리거한 이벤트의 실제 세부 내용입니다. 컨펌 웹훅의 경우 해당 필드의 상세 스키마는 아래와 같습니다.
  - `paymentId`: 고객사에서 채번한 결제건의 고유 주문 번호입니다.
  - `transactionId`: 포트원에서 채번한 결제건의 고유 거래 번호입니다.
  - `totalAmount`: 결제건의 결제 요청 금액입니다.

**컨펌 웹훅 payload 예시:**

```json
{
  "type": "Transaction.Confirm",
  "timestamp": "2024-04-25T10:00:00.000Z",
  "data": {
    "paymentId": "example-payment-id",
    "transactionId": "55451513-9763-4a7a-bb43-78a4c65be843",
    "totalAmount": 1000
  }
}
```

## SDK 실패 응답에 특정 에러 메세지 포함시키기

고객사는 재고 부족 등의 이유로 포트원이 보낸 컨펌 프로세스 요청에 실패 응답을 보낼 수 있고, 이러한 실패 사유를 서비스를 이용하는 고객들에게 보여주고 싶을 수 있습니다.
이러한 경우 Response Body에 `errorMessage` 라는 필드를 포함하여 에러 응답을 보내주시면 해당 메세지를 포함해 SDK 응답으로 리턴해드리고 있습니다.

**Error Response Body 예시:**

```json
{
  "errorMessage": "재고가 모두 소진되었습니다. 관리자에게 문의하세요."
}
```

## 컨펌 웹훅 요청 검증하기

컨펌 프로세스 웹훅 또한 다른 일반적인 웹훅과 동일한 방식으로 검사하시는 것을 권장합니다.
[웹훅 연동하기 - 웹훅 요청 검증하기](https://developers.portone.io/opi/ko/integration/webhook/readme-v2#웹훅-메시지-검증하기)를 참고하셔서 컨펌 웹훅을 신뢰할 수 있는지를 검사하세요.
