---
title: 연동 유의사항
description: 스마트로 연동 유의사항을 소개합니다.
targetVersions:
  - v1
---

## 스마트로와 사전 계약이 필요한 경우

아래 기능을 사용하시려면 스마트로에 사전 신청 후 계약이 완료되어야 합니다.
그렇지 않은 상태에서 해당 기능 이용시 결제 승인에 실패하거나,
승인에 성공하더라도 의도한 바와는 다른 응답
(예: 결제창에서 에스크로 결제를 했으나 비-에스크로 결제 응답을 받음)을 얻게 될 수 있으니 주의해주시기 바랍니다.

- 간편결제 사용
- 면세 / 복합과세 사용
- 할부 사용
- 상점 부담 무이자 할부 사용
- 카드사 포인트 사용
- 에스크로 사용
- \[TBD] 해외 결제 사용

## 테스트모드 유의사항

### 체크카드 결제시, 부분취소 불가능

테스트 모드로 연동시에는 체크카드 결제 건의 경우 전액 취소만 가능하며 부분취소는 불가능합니다.

### 국민카드(카카오뱅크) 결제 불가능

테스트 모드로 연동시에는 국민카드 또는 카카오뱅크로 결제가 불가능합니다.

### 카카오페이 / 페이코 결제시, 삼성/현대/농협/신한 카드 외 결제 불가능

카카오페이 / 페이코 - 테스트 모드 연동시 삼성, 현대, 농협, 신한 카드 외의 카드로는 결제가 불가능합니다.

### 일부 은행(예: K뱅크)의 경우 가상계좌 발급 불가능

테스트 모드로 연동시에는 일부 은행(예: K뱅크, 국민, 전북, 광주, 대구 등)의 경우 가상계좌 발급이 불가능합니다.

### 카카오페이 - 등록된 카드로 결제시, 반드시 직접 취소 필요

테스트모드로 연동시에는 카카오페이 - 등록된 카드로 결제 시, 결제된 금액이 자동으로 취소되지 않으므로
반드시 포트원 REST cancel API(`POST /payments/cancel`)로 직접 취소하셔야 합니다.

## 카드 결제시 유의사항

### 할부 개월수 리스트를 제어할 수 없음

다른 PG사는 `display: { card_quota }` 파라미터로 구매자에게 노출될 할부개월수 리스트 제어가 가능하나
스마트로는 해당 기능을 지원하지 않습니다.

### 무이자 할부 개월수 리스트를 제어할 수 없음

다른 PG사는 `card: { detail }` 파라미터로 구매자에게 노출될 무이자 할부개월수 리스트 제어가 가능하나
스마트로는 해당 기능을 지원하지 않으며 상점 아이디에 등록된 무이자 정보에 따라 자동 표기됩니다.

### 다이렉트 호출시에만 고정 할부 개월수 필수 입력

스마트로의 경우 **카드사 다이렉트 호출시 고정 할부 개월수는 필수 입력**입니다.
마찬가지로 **고정 할부 개월수 지정시 다이렉트 호출 할 카드사 코드는 필수 입력**입니다.
즉, 둘 다 지정하거나 둘 다 지정하지 않거나 둘 중에 하나만 가능합니다.

예를 들어, 5개월 할부로 지정하고 싶은 경우 다른 PG사는 `display: { card_quota: [5] }`
또는 `card: { direct: quota: 5 }`만 지정하면 되지만 스마트로의 경우
고정 할부 개월수는 다이렉트 호출시에만 지원하기 때문에 다이렉트 호출 할 카드사 코드까지 함께 넘겨야 합니다.

마찬가지로 BC카드 다이렉트 호출을 하고 싶은 경우
다른 PG사는 `card: { direct: { code: '361' } }`만 지정하면 되지만
스마트로의 경우 카드사 다이렉트 호출시 고정 할부 개월수는 필수 입력이기 때문에 할부 개월수를 함께 넘겨야 하니다.

<details>

<summary>파라미터 예제 코드</summary>

```json
// 예. BC카드 5개월 할부
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card",
  "card": {
    "direct": {
      // 다이렉트 호출할 카드사 코드와 고정 할부개월수를 모두 지정해야 함
      "code": "361", // BC카드
      "quota": 5 // 5개월 할부
    }
  }
}
```

```json
// 예. 결제창에서 카드사와 할부개월수 선택
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "pay_method": "card"
}

// 다이렉트 호출할 카드사와 고정 할부개월수 모두 지정하지 않아야 함
```

</details>

### 카드사 포인트 사용 여부 파라미터 제어 불가능

스마트로는 상점 아이디 설정에 카드사 포인트 사용 여부가 결정되는 방식입니다.
따라서 다른 PG사와는 달리 `useCardPoint` 파라미터로 카드사 포인트 사용 여부를 설정할 수 없습니다.

### 전북카드와 카카오뱅크 카드 다이렉트 호출은 윈도우 OS에서만 가능

스마트로의 경우 전북 카드(`code: "372"`)와 카카오뱅크 카드(`code: "090"`) 다이렉트 호출은
윈도우 OS에서만 가능하기 때문에 맥 OS에서는 사용이 불가능합니다.

## 간편 결제 시 유의사항

### 구매자 식별값 `customer_id`는 필수 입력

스마트로는 **간편결제시 구매자를 식별할 수 있는 고유 번호인 `customer_id`를 필수**로 입력 받고 있으며, 입력 길이는 **20자로 제한**됩니다.
이는 빌링키 발급 시에도 마찬가지입니다.

### 네이버페이는 카드 결제만 가능

스마트로를 통한 네이버페이 결제 시 등록된 카드로만 결제가 가능하고 네이버페이 포인트/머니 결제는 불가능합니다.
단, 카드 결제창에서 네이버페이를 선택한 경우에는 네이버페이 포인트/머니 결제 또는
네이버페이 카드 결제 둘 중 하나를 선택할 수 있으니 네이버페이 포인트/머니로 결제를 원하시면
카드 결제창 내에서 네이버페이를 선택하여 결제해주시기 바랍니다.

## 가상계좌 결제시 유의사항

### `vbank_due` 파라미터는 필수 입력

스마트로의 경우 **가상계좌 발급시 입금 기한을 의미하는 `vbank_due` 파라미터가 필수**로 요구되며
`YYYYMMDD` 형식의 유효한 날짜(시각은 무조건 `23:59:59`로 설정 됨)만 허용됩니다.

`vbank_due` 파라미터를 전달하지 않거나, 유효하지 않은 날짜를 입력하면 결제창이 호출되지 않습니다.

### 현금영수증 정보 전달 불가능

구매자는 가상계좌나 계좌이체와 같은 현금성 결제시 결제창에서 현금영수증 정보(현금영수증 발급 유형, 현금영수증 발행 식별 번호)를 선택할 수 있습니다.
스마트로의 경우 현금영수증 정보를 파라미터로 받고 있으며, 파라미터로 전달시 결제창에 자동 입력됩니다.

단, 가상계좌 결제 시에는 스마트로 정책상 다이렉트 호출시에만 현금영수증 정보를 파라미터로 전달할 수 있는데
V1에서는 가상계좌 다이렉트 호출을 지원하지 않기 때문에 **가상계좌 결제시에는 현금영수증 정보를 파라미터로 전달할 수 없**으니 참고 바랍니다.

## 휴대폰 소액결제시 유의사항

### `digital` 파라미터는 필수 입력

스마트로의 경우 **휴대폰 소액결제시 상품 유형을 구분 짓는 `digital` 파라미터가 필수**로 요구됩니다.
상품 유형이 디지털 컨텐츠인 경우 `true`를, 실물인 경우엔 `false`를 전달합니다.

### `digital` 파라미터가 올바르지 않은 경우 결제 불가

스마트로 상점 아이디 설정에 따라 올바른 `digital` 파라미터 값이 정해져 있습니다.
만약 해당 상점 아이디 설정이 디지털 컨텐츠 판매용인 경우, `digital` 파라미터를 `true`로 보내야 하는데
이를 보내지 않거나 `false`로 보내는 경우엔 아래와 같은 팝업이 노출되며 결제를 더 이상 진행할 수 없습니다.

<details>

<summary>고객사 설정 정보와 다른 `digital` 파라미터가 입력 된 경우</summary>

(관련 이미지 첨부)

</details>

## 빌링키 발급시 유의사항

### 빌링키 발급 창에서는 언어 설정 미지원

스마트로는 결제창 언어로 한글(`language: "ko"`)과 영어(`language: "en"`)를 지원하지만, 빌링키 발급 창에서는 한글만 지원합니다.

### 구매자 식별값 `customer_id`는 필수 입력

스마트로는 **빌링키 발급시 구매자를 식별할 수 있는 고유 번호인 `customer_id`를 필수**로 입력 받고 있으며,
입력 길이는 **20자로 제한**됩니다. 이는 간편결제 시에도 마찬가지입니다.

### 본인인증 프로세스 존재

스마트로는 다른 PG사와는 다르게 **빌링키 발급시 휴대폰 본인인증 프로세스가 존재**합니다.
단, 한 번 인증 받은 "구매자"는 다시 인증 받을 필요가 없는데 이 "구매자"를 식별하기 위해 위에 언급한 `customer_id`가 사용되고 있습니다.

즉, 기존에 빌링키 발급 시 사용한 `customer_id`를 재사용하면 휴대폰 본인인증 프로세스가 생략되지만,
새로운 `customer_id`로 빌링키 발급을 시도하면 휴대폰 본인인증 후 빌링키 발급이 진행됩니다.

|customer\_id|customer\_uid|카드사  |빌링키 발급 프로세스                                                                                                       |
|------------|-------------|--------|---------------------------------------------------------------------------------------------------------------------------|
|cid\_A      |cuid\_A      |현대카드|본인인증 <br /> → 현대카드로 빌링키 발급                                                                                   |
|            |cuid\_B      |우리카드|이미 본인인증을 완료 한 customer\_id이므로 본인인증 생략 <br /> → 우리카드로 빌링키 발급                                   |
|            |cuid\_A      |신한카드|이미 본인인증을 완료 한 customer\_id이므로 본인인증 생략 <br /> → cuid\_A에 신한카드가 override / cuid\_B는 여전히 우리카드|
|cid\_B      |cuid\_C      |삼성카드|새로운 customer\_id이므로 본인인증 <br /> → 삼성카드로 빌링키 발급                                                         |

## 에스크로 결제시 유의사항

### 에스크로 결제시 카드사/가상계좌 은행 다이렉트 호출 불가능

스마트로는 에스크로 결제 시 카드사 다이렉트 호출 및 가상계좌 은행 다이렉트 호출(V2만 사용 가능)이 불가능합니다.
만약 에스크로 결제 시 아래와 같이 다이렉트 호출을 할 경우 결제창이 호출되지 않으니 유의하시기 바랍니다.

<details>

<summary>V1 에스크로 + 카드사 다이렉트 호출</summary>

```tsx {5-11}
IMP.request_pay({
  channelKey: "{콘솔 내 연동 정보의 채널키}",
  pay_method: "card",
  amount: 50000,
  escrow: true, // 에스크로 결제
  card: {
    direct: {
      code: "361", // 카드사 다이렉트 호출
      quota: 5,
    },
  },
});
```

</details>

<details>

<summary>V2 에스크로 + 카드사 다이렉트 호출</summary>

```tsx {5-13}
PortOne.requestPayment({
  pgProvider: "SMARTRO_V2",
  payMethod: "CARD",
  totalAmount: 50000,
  isEscrow: true, // 에스크로 결제
  card: {
    cardCompany: "BC_CARD", // 카드사 다이렉트 호출
    installment: {
      monthOption: {
        fixedMonth: 5,
      },
    },
  },
});
```

</details>

<details>

<summary>V2 에스크로 + 가상계좌 다이렉트 호출</summary>

```tsx {5-8}
PortOne.requestPayment({
  pgProvider: "SMARTRO_V2",
  payMethod: "VIRTUAL_ACCOUNT",
  totalAmount: 50000,
  isEscrow: true, // 에스크로 결제
  virtualAccount: {
    bankCode: "SHINHAN_BANK", // 은행 다이렉트 호출
  },
});
```

</details>

### 에스크로 + 계좌이체 결제 시 현금영수증 자동 입력 불가능

스마트로는 계좌이체 결제 시 결제창에 자동으로 입력될 현금영수증 정보(`cashReceiptType`: 현금영수증 유형,
`customerIdentifier`: 현금영수증 식별 값)를 파라미터로 전달할 수 있습니다.
단, 에스크로 결제 시에는 전달이 불가능합니다. 만약 에스크로 + 계좌이체 결제시 아래와 같이
현금영수증 정보를 전달할 경우 결제창이 호출되지 않으니 유의하시기 바랍니다.

<details>

<summary>V1 에스크로 + 계좌이체 + 현금영수증 정보 전달</summary>

```tsx {4-10}
IMP.request_pay({
  channelKey: "{콘솔 내 연동 정보의 채널키}",
  amount: 50000,
  pay_method: "trans", // 계좌이체 결제
  escrow: true, // 에스크로 결제
  bypass: {
    // 현금영수증 정보 전달
    cashReceiptType: "company",
    customerIdentiifer: "1178178260",
  },
});
```

</details>

<details>

<summary>V2 에스크로 + 계좌이체 + 현금영수증 정보 전달</summary>

```tsx {4-10}
PortOne.requestPayment({
  pgProvider: "SMARTRO_V2",
  totalAmount: 50000,
  payMethod: "TRANSFER", // 계좌이체 결제
  isEscrow: true, // 에스크로 결제
  transfer: {
    // 현금영수증 정보 전달
    cashReceiptType: "company",
    customerIdentiifer: "1178178260",
  },
});
```

</details>

## 기타 유의사항

### 주문 번호에 특수문자 입력 불가능

스마트로는 주문 번호(`merchant_uid`)에 특수문자를 허용하고 있지 않습니다.
따라서 결제창에서 일반결제를 할 때와 발급된 빌링키로 API를 통해 재결제를 하는 경우
숫자, 문자(알파벳 소문자와 대문자) 또는 그 조합으로 이루어진 주문 번호를 사용해주세요.

### 주문 번호 40자 길이 제한

스마트로는 주문 번호(`merchant_uid`)가 최대 40자를 넘을 수 없습니다.
40자가 넘을 경우 40자까지 잘려서 저장되기 때문에 유의 바랍니다.

### 결제 통화 파라미터 제어 불가능

스마트로는 상점 아이디 설정에 따라 사용 가능한 통화가 자동으로 정해지는 방식입니다.
따라서 다른 PG사와는 달리 currency 파라미터로 결제 통화를 설정할 수 없습니다.

단, 스마트로가 지원하지 않는 화폐(KRW와 USD를 제외한 값)를 전달할 경우
`"스마트로가 지원하지 않는 화폐입니다"`라는 에러가 발생하며 결제를 진행할 수 없으니 유의 바랍니다.

또한 스마트로 이슈로 인해 당분간 **USD 결제는 불가능하며 KRW 결제만 가능**하니 참고 바랍니다.

### 제공 기간은 시작 날짜와 종료 날짜를 모두 입력해야 함

스마트로는 결제창 내 서비스 제공 기간을 노출시킬 수 있도록 period 파라미터를 optional로 제공하고 있습니다.
단, 시작 날짜(`from`)와 종료 날짜(`to`)를 모두 입력해야 결제창에 정상적으로 노출되며
**둘 중 하나만 입력하거나 유효(`YYYMMDD`)하지 않은 날짜 형식을 입력하면 결제창에 노출되지 않**습니다.

<details>

<summary>파라미터 예시</summary>

```json
{
  "channelKey": "{콘솔 내 연동 정보의 채널키}",
  "period": {
    // 서비스 제공 시작 날짜와 종료 날짜를 모두 입력해야 함
    "from": "2023-01-01", // 서비스 제공 시작 날짜
    "to": "2023-03-31" // 서비스 제공 종료 날짜
  }
}
```

(관련 이미지 첨부)

</details>

### 현금성 결제 시 `cashReceiptType` 값에 따라 `customerIdentifier` 입력 정책이 달라짐

스마트로의 경우 현금성 결제 시, bypass 파라미터에 현금영수증 발급 정보를 아래와 같이 전달할 수 있습니다.

<div class="hint" data-style="info">

단, 가상계좌 결제 시에는 스마트로 정책상 다이렉트 호출 시에만 현금영수증 정보를 파라미터로 전달할 수 있는데
V1에서는 가상계좌 다이렉트 호출을 지원하지 않기 때문에
**가상계좌 결제시에는 현금영수증 정보를 파라미터로 전달할 수 없**으니 참고 바랍니다.

</div>

```json
{
  "bypass": {
    "cashReceiptType": "corporate", // 현금영수증 발급 유형
    "customerIdentifier": "1178178260" // 현금영수증 발행 대상 식별 정보
  }
}
```

이때 전달하는 `cashReceiptType` 파라미터 값에 따라 `customerIdentifier` 파라미터 입력 정책이 아래와 같이 달라지기 때문에 주의가 요구됩니다.

|cashReceiptType|customerIdentifier                                                     |
|---------------|-----------------------------------------------------------------------|
|미입력         |입력 불가(결제창에서 입력)                                             |
|anonymous      |입력 불가(결제창에서도 입력 불가)                                      |
|personal       |핸드폰 번호, 주민등록번호, 국세청 현금영수증 카드 번호 중 1개 필수 입력|
|corporate      |사업자 등록번호 필수 입력                                              |

만약 `cashReceiptType: "anonymous"` 또는 입력하지 않은 상태로 `customerIdentifier`를 입력하거나
`cashReceiptType`이 `"personal"` 또는 `"corporate"`인데 `customerIdentifier`를 입력하지 않으면
에러가 리턴되면서 결제창이 호출되지 않습니다.
