---
title: 용어 사전
description: 온라인 결제 시스템에서 자주 사용되는 용어들을 설명합니다.
targetVersions:
  - v1
  - v2
---

## 결제 대행 관련

### PG (Payment Gateway)

PG는 온라인 결제에서 결제 정보를 송수신하고 정산을 매개하는 서비스입니다. 온라인 결제를 받기 위해서는 PG사와의 계약과 연동이 필요합니다. 법적으로는 전자금융업상 전자지급결제대행업에 해당합니다.

PG에 따라 신용카드, 계좌이체, 가상계좌, 휴대폰 결제 등 다양한 결제 수단을 이용할 수 있으며, "결제의 관문"이라는 이름처럼 알맞은 시스템으로 결제 정보를 전달합니다.

### 포트원 원 페이먼트 인프라 (OPI)

다양한 PG의 파편화된 인터페이스를 통일하여 현대적인 연동 경험을 제공하는 **결제 오케스트레이션 서비스**입니다. 이를 통해 PG를 쉽게 연동 및 추가/변경하고, 다중 PG 시스템을 운영할 수 있습니다.

<div class="hint" data-style="info">

OPI 서비스는 결제 정보를 송수신하지만 자금 이동에는 관여하지 않습니다.

</div>

### PG 상점 아이디 (MID)

PG에서 상점에 부여하는 고유 식별자입니다. PG와의 계약을 통해 발급되며, 결제 수단, 과세 여부, 수수료 등 여러 설정이 MID 단위로 관리됩니다. PG 정책에 따라서는 이용 서비스 및 세부 설정별로 여러 개의 MID를 발급하기도 합니다.

포트원을 이용할 때에는 채널을 추가할 때 MID를 입력합니다.

<div class="hint" data-style="info">

**PG사별 상점 아이디 명칭**

- KG이니시스: 상점 아이디(MID)
- 카카오페이: 고객사 코드(CID)
- 네이버페이: 파트너 ID (하위 식별자로 체인 ID 존재)
- 토스페이먼츠: 상점 아이디(MID)
- NHN KCP: 사이트 코드

</div>

### 포트원 상점 아이디 (storeId)

포트원 관리자 콘솔에서 확인할 수 있는 상점 식별자입니다. 연동 시 `storeId`라는 이름으로 많은 API에 등장합니다.

포트원 V1에서는 고객사 식별코드라는 별도 값을 이용합니다.

## 결제 방식 관련 용어

### 간편결제사

네이버페이, 카카오페이, 토스페이, 페이코와 같이 신용카드나 계좌번호 등의 결제 정보를 등록해 비밀번호 입력, 지문 인식만으로 결제할 수 있는 서비스를 제공하는 사업자입니다.

### PG 제휴 간편결제

간편결제사와 직접 계약을 맺지 않고 일반 PG사와의 계약만으로 간편결제사의 서비스 이용이 가능한 서비스입니다. 구매자가 보기에는 동일한 간편결제사의 결제창이 호출됩니다.

<div class="hint" data-style="warning">

**PG 제휴 간편결제 주의사항**

PG 제휴로 간편결제를 이용할 경우 간편결제 포인트 적립이 안 되는 등 일부 기능을 사용할 수 없는 경우가 있습니다.

</div>

### 인증결제

신용카드, 간편결제, 계좌이체, 휴대폰 결제 등에서 결제 정보가 본인임을 확인하는 과정을 거친 이후 결제되는 방식을 총칭합니다. 쇼핑몰 등에서 이용되는 일회성 결제로 가장 일반적인 결제 방식입니다.

### 키인결제

카드 번호 등 결제 정보를 구매자로부터 직접 입력받아 API 호출을 통해 결제를 일으키는 비인증결제 방식입니다.

### 빌링결제

구매자에게 최초 1회 결제 정보를 입력받아 빌링키를 발급함으로써, 이후에 고객사에서 임의 시점에 결제를 반복하여 일으키는 결제 방식입니다. 결제를 일으킬 때에는 별도로 사용자 인증이 필요 없으므로 비인증결제에 속합니다. 정기결제 등을 구현하기 위해 사용합니다.

<div class="hint" data-style="warning">

**빌링키 사용 제한**

빌링키는 해당 빌링키를 발급한 PG에서만 사용 가능합니다. 또, 빌링키를 다른 포트원 상점 또는 다른 PG MID로 이관하려면 별도 요청이 필요합니다.

</div>

## 거래 식별 관련 용어

### 결제 ID (paymentId, 고객사 주문번호)

결제를 요청할 때 고객사가 채번한 고유 번호입니다. V1에서는 `merchant_uid`라는 이름을 사용합니다.

### PG 거래번호 (TID)

PG사가 채번한 거래 번호입니다. PG사에 따라 취소 건에도 별도의 거래 번호를 부여할 수 있습니다.

### 카드 승인번호

승인 성공 시 카드사가 부여한 8자리 숫자로, 매입을 진행하거나 취소를 할 때 필요합니다. 당일에 한 카드사에 유니크하나 몇몇 카드사는 당일에 중복되는 경우도 있습니다.

## 카드 결제

신용/체크/선불카드를 통한 결제는 인증, 승인, 매입의 과정을 거칩니다.

### 인증 (Authentication)

인증결제에서, 카드 소유주가 본인임을 확인하는 과정입니다. 웹에서 비밀번호를 입력하거나 앱에서 지문 인식을 하는 등 카드사마다 방식이 다릅니다.

### 승인 (Authorization)

승인 거래가 생성되고, 카드 한도를 차감합니다. 실제로 대금이 이동하지는 않습니다.

포트원에서는 인증이 완료되면 자동으로 승인을 진행합니다. 또는, V2에서 수동 승인 기능을 이용하면 인증 후 승인 요청을 별도로 할 수 있습니다.

### 매입 (Capture)

매입은 승인된 카드 거래의 대금을 청구하는 일을 말합니다. 일반적으로 PG가 매일 정해진 시간에 승인 건들을 모아 자동으로 매입합니다.

결제 승인 시점과 상품 공급 시점이 크게 다른 상점에서는 자동 매입을 끄고 PG에 건별로 매입을 요청하는 수동 매입을 이용할 수 있습니다. 매입이 오랫동안 일어나지 않으면 자동으로 승인이 취소됩니다. 포트원에서는 아직 수동 매입을 지원하지 않습니다.

카드 결제를 취소할 경우 원리상 매입 전 취소와 매입 후 취소가 구분되고, 매입 후 취소는 보통 3\~4 영업일이 소요됩니다.

## 카드 관련 용어

### 카드사 유형

신용, 체크카드와 관련된 개념으로 발급사, 매입사, 네트워크(브랜드)가 있습니다.

- **발급사**: 카드를 발급한 회사
- **매입사**: 상점과 계약하여 카드 거래 매입을 담당하는 회사
- **네트워크**: 매입사와 발급사 사이를 중개하는 인프라 (비자, 마스터카드, JCB, 아메리칸 익스프레스, 다이너스 클럽, 디스커버, 유니온페이 등)

국내는 카드에 따라 매입사가 하나로 정해져 있기 때문에 PG가 각 매입사와 계약을 맺습니다.

<div class="hint" data-style="info">

**예시: 카카오뱅크 카드**

- 발급사: 카카오뱅크
- 매입사: 국민카드
- 네트워크: 없음 (해외 사용 시 비자, 마스터카드 등 선택)

</div>

### PLCC (Private Label Credit Card)

상업자표시 신용카드로, 카드명에 특정 브랜드를 표기한 것을 말합니다. 제휴 업체와 함께 카드 상품을 공동으로 기획하여 비용과 수익을 분담하며, 제휴사의 충성도 높은 고객을 확보할 수 있는 장점이 있습니다.

**PLCC 예시:**

- 스타벅스 현대카드
- 배민 현대카드
- 11번가 신한카드

### 제휴카드

카드사가 특정 기업 혹은 단체와 협약을 맺어 발급하는 카드입니다. 카드사는 제휴사 카드 상품을 출시하고 마케팅 비용이나 카드 수익 등을 모두 관리하며, 반면 제휴사는 카드 모집만 담당합니다.

## 기타 결제 관련 용어

### 가상계좌

은행이 고객사에 발급한 입금 전용 계좌로, 고객사는 납부자와 가상계좌 번호를 일대일로 매핑하여 발급합니다. 보통 가상계좌는 입금 시 바로 삭제되며 해당 계좌번호는 재활용되어 다른 납부자에게 발급될 수 있습니다.

### 고정식 가상계좌

전기요금 고지서처럼 납부자가 하나의 입금 계좌번호를 부여받아 지속적으로 입금하고자 할 때 이용하는 가상계좌입니다.

### 에스크로

구매자의 구매 확인 의사인 구매결정을 통보받은 후 판매자에게 결제 대금을 지급하는 안전한 결제 서비스입니다. 2006년 4월 1일부터 에스크로 의무화 시행에 따라 가상계좌, 계좌이체와 같은 모든 현금 거래에는 의무적으로 적용해야 합니다.

## 취소

결제 완료 이후에 API나 콘솔을 통해 결제를 취소할 수 있습니다. 결제 금액의 일부만 취소하는 것도 가능합니다.

가상계좌 환불이나 휴대폰 익월 환불의 경우 환불받을 계좌를 입력해야 합니다.

환불 가능 기한이 지난 등의 이유로 PG를 통한 취소가 불가능한 경우에는 고객사에서 직접 구매자에게 자체 환불 처리해야 합니다.

### 카드

매입 전 취소의 경우 즉시 환불됩니다. 매입 후 취소는 일반적으로 3\~4 영업일이 소요됩니다.

### 계좌이체

즉시 환불됩니다.

### 가상계좌

환불받을 계좌를 입력해야 환불이 가능합니다. 일반적으로 2 영업일이 소요됩니다.

### 휴대폰

결제가 일어난 해당 월에만 취소가 가능합니다. 실제 지불 전이므로 즉시 취소됩니다. 일부 PG에서는 익월 환불이라 하여 해당 월이 지난 뒤에도 계좌로 환불하는 기능을 제공합니다.

## 세금 관련 용어

### 부가가치세

일반적으로 매출 발생시 10%의 부가가치세를 국가에 납부해야 합니다. 또한, PG 서비스 수수료에도 10%의 부가가치세가 발생합니다. 수수료에 대한 부가가치세는 매입 세액에 속합니다.

<div class="hint" data-style="info">

**정산 수수료 계산 예시**

1,000원의 결제에 대해 3%의 수수료를 적용한다면:

- 수수료: 30원
- 수수료 부가세: 3원 (수수료의 10%)
- 정산 금액: 967원

</div>

### 면세

세금을 부과하지 않는 소득을 의미합니다. 저소득층의 세금 부담 경감 또는 기타 정책적 목적으로 일부 재화나 용역의 공급에 대해 부가가치세를 면제하는 것을 말합니다. 대표적으로 기초생활필수품, 문화 관련 재화, 용역 등이 있습니다.

### 영세율

일정한 재화 또는 용역의 공급에 대해 0의 세율을 적용하는 제도로, 수출업자, 기타 외화 획득 사업자 등이 영세사업자로 적용됩니다.

## 할인 관련 용어

### 즉시할인

상품의 가격에 즉시 할인 금액을 적용하여 할인된 금액을 결제하는 방식입니다.

### 청구할인

본래의 상품 가격을 결제했다가 조건 충족 시 결제 대금의 할인된 금액이 반영되는 방식입니다. 청구할인은 할인 여부를 챙겨봐야 하기 때문에 즉시할인이 납부자에게 더 선호됩니다.
